//+------------------------------------------------------------------+
//|                        Digital PCCI Filter                       |
//|                      Copyright (c) Sergey Iljukhin, Novosibirsk. |
//|                         mailto:sergey@tibet.ru http://fx.qrz.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright (c) 2005, Sergey Iljukhin, Novosibirsk"
#property link      "mailto:sergey@tibet.ru"

// --- Parameters: P1=38, D1=28, A1=40
// --- P2=52, D2=31, A2=40, Ripple=0.08, Delay=0
// --- Order [Auto]=106, Calculate method=2

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Red
  
//---- buffers
double FilterBuffer[];

//+------------------------------------------------------------------+
//| Digital filter indicator initialization function                 |
//+------------------------------------------------------------------+
int init()
{
string short_name;
//---- indicator line
SetIndexStyle(0,DRAW_LINE);
SetIndexBuffer(0,FilterBuffer);
SetIndexDrawBegin(0,106);
//----
return(0);
}
//+------------------------------------------------------------------+
//| Digital filter main function                                     |
//+------------------------------------------------------------------+
int start()
{
int i,counted_bars=IndicatorCounted();
double response;
//----
if(Bars<=106) return(0);
//---- initial zero
if(counted_bars<106)
for(i=1;i<=0;i++) FilterBuffer[Bars-i]=0.0;
//----
i=Bars-106-1;
if(counted_bars>=106) i=Bars-counted_bars-1;
while(i>=0)
{
response=
 0.1177628838235*Close[i+0]
 +0.1170077388431*Close[i+1]
 +0.1147601209029*Close[i+2]
 +0.1110729054065*Close[i+3]
 +0.1060324421434*Close[i+4]
 +0.0997560988008*Close[i+5]
 +0.0923890376402*Close[i+6]
 +0.0841000389219*Close[i+7]
 +0.0750766919597*Close[i+8]
 +0.0655202662708*Close[i+9]
 +0.0556401583046*Close[i+10]
 +0.0456482572592*Close[i+11]
 +0.0357530528012*Close[i+12]
 +0.02615415804227*Close[i+13]
 +0.01703731282680*Close[i+14]
 +0.00856960311288*Close[i+15]
 +0.000895555708556*Close[i+16]
 -0.00586627422066*Close[i+17]
 -0.01162552971203*Close[i+18]
 -0.01632152444323*Close[i+19]
 -0.01992414580732*Close[i+20]
 -0.02243335117589*Close[i+21]
 -0.02387813894599*Close[i+22]
 -0.02431430200598*Close[i+23]
 -0.02382176331725*Close[i+24]
 -0.02250140527159*Close[i+25]
 -0.02047075493180*Close[i+26]
 -0.01786000052706*Close[i+27]
 -0.01480733499641*Close[i+28]
 -0.01145463232852*Close[i+29]
 -0.00794304696010*Close[i+30]
 -0.00440829083275*Close[i+31]
 -0.000977238472653*Close[i+32]
 +0.002235823933755*Close[i+33]
 +0.00513191787383*Close[i+34]
 +0.00762972457736*Close[i+35]
 +0.00966747623918*Close[i+36]
 +0.01120310303187*Close[i+37]
 +0.01221499285956*Close[i+38]
 +0.01270127547603*Close[i+39]
 +0.01267881242200*Close[i+40]
 +0.01218165493397*Close[i+41]
 +0.01125820035359*Close[i+42]
 +0.00996954486984*Close[i+43]
 +0.00838605323109*Close[i+44]
 +0.00658436935337*Close[i+45]
 +0.00464439195323*Close[i+46]
 +0.002645759417416*Close[i+47]
 +0.000666068159555*Close[i+48]
 -0.001222776729259*Close[i+49]
 -0.002956488520058*Close[i+50]
 -0.00448011021214*Close[i+51]
 -0.00574988855361*Close[i+52]
 -0.00673332989225*Close[i+53]
 -0.00741117882839*Close[i+54]
 -0.00777644547070*Close[i+55]
 -0.00783388153265*Close[i+56]
 -0.00759966748743*Close[i+57]
 -0.00709931269272*Close[i+58]
 -0.00636769053766*Close[i+59]
 -0.00544559940274*Close[i+60]
 -0.00437852874428*Close[i+61]
 -0.00321542503890*Close[i+62]
 -0.002005580069262*Close[i+63]
 -0.000798178859997*Close[i+64]
 +0.000361723322003*Close[i+65]
 +0.001433101593600*Close[i+66]
 +0.002380073229874*Close[i+67]
 +0.00317453700490*Close[i+68]
 +0.00379492177651*Close[i+69]
 +0.00422884523807*Close[i+70]
 +0.00447038314289*Close[i+71]
 +0.00452100306476*Close[i+72]
 +0.00439082398691*Close[i+73]
 +0.00409492037175*Close[i+74]
 +0.00365528338580*Close[i+75]
 +0.003096238149856*Close[i+76]
 +0.002446112685573*Close[i+77]
 +0.001736376831290*Close[i+78]
 +0.000996103380422*Close[i+79]
 +0.0002557237615143*Close[i+80]
 -0.000458282529397*Close[i+81]
 -0.001119581482823*Close[i+82]
 -0.001704893115208*Close[i+83]
 -0.002199032152313*Close[i+84]
 -0.002586916898054*Close[i+85]
 -0.002861741841535*Close[i+86]
 -0.003018651749353*Close[i+87]
 -0.003060101508137*Close[i+88]
 -0.002997112675297*Close[i+89]
 -0.002834938217095*Close[i+90]
 -0.002589089321820*Close[i+91]
 -0.002272072078644*Close[i+92]
 -0.001902835889698*Close[i+93]
 -0.001502872027811*Close[i+94]
 -0.001077466851623*Close[i+95]
 -0.000655481642188*Close[i+96]
 -0.0002511660753314*Close[i+97]
 +0.0001137882502083*Close[i+98]
 +0.000426098842482*Close[i+99]
 +0.000714775119642*Close[i+100]
 +0.000916639580735*Close[i+101]
 +0.001063116482197*Close[i+102]
 +0.001143113996535*Close[i+103]
 +0.001159315803654*Close[i+104]
 +0.00922554212244*Close[i+105];
FilterBuffer[i]=Close[i]-response;

i--;
}
return(0);
}